﻿<!doctype html>
<html lang="en">
    <head>
        <meta charset="UTF-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <!-- Main Page Title -->
        <title>About Us | ForceField Compressor Inc</title>
        <?php $page = 'about-us'; include 'head.php';?>
    </head>
    <body>
        <?php include 'header.php';?>

        <!--==================================================================== 
							Start Header 
	=====================================================================-->
        <section
            id="page"
            class="header-breadcrumb"
            style="background-image: url(assets/images/header/page-banner.jpg);background-position: top !important;"
        >
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <span class="page-title-line">Introduction</span>
                        <h1 class="page-title-heading">About Us</h1>
                    </div>
                </div>
            </div>
        </section>
        <!--==================================================================== 
							End Header 
	=====================================================================-->

        <!--==================================================================== 
							Start Section Features One
	=====================================================================-->
        <div class="features pt-60 pb-30">
            <div class="container">
                <div class="row section-title">
                    <div class="col-md-5">
                        <h2>Quality you can trust</h2>
                        <h3>Our Mission & Vision</h3>
                    </div>

                    <div class="col-md-7">
                        <p class="p-title-section">
                            Our custom approach ensures that each component is designed to meet your specific
                            operational needs, enhancing the efficiency and reliability of your compressor systems.
                        </p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6 col-lg-6">
                        <div class="services-item-two">
                            <div class="content-box">
                                <span class="flaticon-thinking"></span>
                                <h4>Our Mission</h4>
                                <p>
                                    We recognized the value and importance of our customers. We promote the concept of continuous customer satisfaction as the responsibility of our organisation and consider it as our final goal. As a business organisation we strive for the consistency and perfection and we pledge our knowledge to our valued customers.
                                </p>
                            </div>
                            <div
                                class="services-box-img"
                                style="background-image: url(assets/images/about/mission.jpg)"
                            ></div>
                        </div>
                    </div>

                    <div class="col-sm-6 col-lg-6">
                        <div class="services-item-two">
                            <div class="content-box">
                                <span class="flaticon-idea"></span>
                                <h4>Our Vision</h4>
                                <p>
                                    ForceField has grown in to an industry leader in the field of Screw, Reciprocating Compressors and Vacuum Pumps aftermarket, replacement, equivalent Spare Parts. Developing a diverse product line and establishing a global customer base, thereby increasing sales and identifying additional product development opportunities.
                                </p>
                            </div>
                            <div
                                class="services-box-img"
                                style="background-image: url(assets/images/about/vision.jpg)"
                            ></div>
                        </div>
                    </div>
				</div>
            </div>
        </div>

        <!--==================================================================== 
							End Section Features One
	=====================================================================-->

        <!--==================================================================== 
							Start Section About Us Three
	=====================================================================-->
        <section id="about" class="about about-three">
            <div class="about-one pb-20 pt-60">
                <div class="container">
                    <div class="row">
                        <div class="col-md-6 mb-50">
                            <div class="slider-about">
                                <div class="about-img-three">
                                    <img src="assets/images/about/about-1.jpg" alt="about" />
                                </div>
                                <div class="overlay-about-three"></div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-20">
                            <div class="info-about">
                                <div class="section-title-left">
                                    <h2>about us</h2>
                                    <h3>A Little About Us</h3>
                                </div>

                                <p class="p-about-thtee">
                                    ForceField is one of the leading manufacturer and suppliers for domestic and
                                    international market. We supply more than 45 brand & Manufacture of Air and Gas
                                    Compressor part & Kits over 32 countries around the world.
                                </p>

                                <div class="why-us mb-20">
                                    <div class="row">
                                        <div class="col-sm-12 col-lg-12">
                                            <h5>Compressor Parts</h5>
                                            <ul class="list-feat">
                                                <li><span></span>For Air/Gas, Screw Compressor</li>
                                                <li>
                                                    <span></span>Atlas Copco, ABC, Ariel, Belliss Morcom, Crepelle,
                                                    Thome Crepelle, Chicago Pneumatic, Dresser Rand, Ingersoll Rand,
                                                    Didwania, Elgi, Sabroe, Carrier, Trane, Broomwade, Bitzer, Josef
                                                    Mehrer, Hoerbiger, Quincy, Sullair, Cecatto, KG Khosla, Kirloskar,
                                                    Kaeser
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!--==================================================================== 
							End Section About Us three
	=====================================================================-->

        <!--==================================================================== 
							Start Work Process
	=====================================================================-->
        <div class="work-process pt-120">
            <div class="overlay"></div>
            <div class="container">
                <div class="row section-title">
                    <div class="col-md-5">
                        <h2 class="color-gray">Satisfaction Matter</h2>
                        <h3 class="color-white">Quality Policy</h3>
                    </div>

                    <div class="col-md-5">
                        <p class="p-title-section color-gray">
							Our well equipped workshop and highly trained personnel manufactures <strong>“ Top Quality Parts”</strong>
                        </p>
                    </div>
                </div>

                <div class="row content-process">
                    <div class="col-md-12 no-padding">
                        <div class="item-process">
                            <h6 class="mb-10">
                                At ForceField, Quality is an integral part of our Business Principles. These principles
                                guide our actions to deliver products and services that are safe, compliant and
                                preferred by our customers. We are determined to:
                            </h6 class="mb-10">
                            <ul class="indicator">
                                <li>
                                    <span class="fa fa-check"></span>

                                    Foster a quality culture with the objective of developing, manufacturing and
                                    providing products and services with zero defects that are trusted and preferred by
                                    our customers.t
                                </li>

                                <li>
                                    <span class="fa fa-check"></span> Comply with relevant laws and regulations as well
                                    as internal requirements.
                                </li>

                                <li>
                                    <span class="fa fa-check"></span>

                                    Continuously challenge our team to improve the company quality management systems,
                                    prevent quality incidents, and eliminate defects through the review of quality
                                    objectives and results.
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--==================================================================== 
							End Work Process
	=====================================================================-->
        <!--==================================================================== 
							Start Section Services
	=====================================================================-->
        <section id="service" class="services services-three pt-160 pb-60">
            <!--========== My Services Info ==========-->
            <div class="container">
                <div class="row">
                    <!-- Services Items Column -->
                    <div class="col-lg-4 col-sm-6">
                        <div class="services-item-three">
                            <div class="content-box">
                                <span><img src="assets/images/icons/original.png" /></span>
                                <h4>
                                    100% Interchangeable with OEM parts
                                </h4>
                                <p>
                                    ForceField’s products are backed by over 100 years of combined engineering and compressor repair experience. This ensures ForceField has a thorough understanding of each part’s function and critical design features which results in parts that are well manufactured and perform as the OEM intended.<br><br>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-6">
                        <div class="services-item-three">
                            <div class="content-box">
                                <span><img src="assets/images/icons/achievement.png" /></span>
                                <h4>
                                    Highest quality metallic plates and rings
                                </h4>
                                <p>
                                    ForceField’s state-of-the-art laser cutting equipment guarantees precisely cut metallic plates. Our proprietary stress-relieving procedures have dramatically improved part quality when flatness is critical. ForceField’s finishing processes ensure that our metallic plates are optimized for maximum abrasion resistance and durability.
                                </p>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-sm-6">
                        <div class="services-item-three">
                            <div class="content-box">
                                <span><img src="assets/images/icons/security.png" /></span>
                                <h4>
                                    Durable thermoplastic plates and rings
                                </h4>
                                <p>
                                    ForceField’s state-of-the-art in-house injection molding machines and proprietary molds ensure remarkable plate and ring durability. Our unique molds have been engineered to eliminate stress that is typically found with other vendor’s parts. Simply put, our stress-free parts result in better sealing and improved valve plate lifespan and performance.
                                </p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>
        <!--==================================================================== 
							End Section Services
	=====================================================================-->

<!--==================================================================== 
							Start Statistics
	=====================================================================-->
        <div class="statistics statistics-two statistics-three pt-60 pb-30">
            <div class="container">
                <div class="row">
                    <div class="col-md-3 col-sm-6">
                        <div class="stat-item">
                            <span class="flaticon-cart"></span>
                            <div class="count" data-from="1" data-to="6500" data-speed="3000"></div>
                            <p class="text">Products</p>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6">
                        <div class="stat-item">
                            <span class="flaticon-worker"></span>
                            <div class="count" data-from="1" data-to="126" data-speed="3000"></div>
                            <p class="text">team Engineers</p>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6">
                        <div class="stat-item">
                            <span class="flaticon-globe"></span>
                            <div class="count" data-from="1" data-to="4800" data-speed="3000"></div>
                            <p class="text">Clients Worldwide</p>
                        </div>
                    </div>

                    <div class="col-md-3 col-sm-6">
                        <div class="stat-item last-item">
                            <span class="flaticon-wrench"></span>
                            <div class="count" data-from="1" data-to="35" data-speed="3000"></div>
                            <p class="text">Years of Experiences</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--==================================================================== 
							End Statistics
	=====================================================================-->

        <!--==================================================================== 
                        Start Footer
		=====================================================================-->
		
		<?php include 'footer.php';?>
    </body>
</html>
